/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model.expression;

import com.thoughtworks.qdox.model.expression.AnnotationValue;
import com.thoughtworks.qdox.model.expression.ExpressionVisitor;
import java.util.regex.Pattern;

public abstract class Constant
implements AnnotationValue {
    private final String image;

    private Constant(String image) {
        this.image = image;
    }

    public abstract Object getValue();

    public static Constant newBooleanLiteral(final String value) {
        return new Constant(value){

            @Override
            public Object getValue() {
                return 1.toBoolean(value);
            }
        };
    }

    public static Constant newCharacterLiteral(final String value) {
        return new Constant(value){

            @Override
            public Object getValue() {
                return 2.toChar(value);
            }
        };
    }

    public static Constant newFloatingPointLiteral(final String value) {
        return new Constant(value){

            @Override
            public Object getValue() {
                return 3.toFloatingPointLiteral(value);
            }
        };
    }

    public static Constant newIntegerLiteral(final String value) {
        return new Constant(value){

            @Override
            public Object getValue() {
                return 4.toIntegerLiteral(value);
            }
        };
    }

    public static Constant newStringLiteral(final String value) {
        return new Constant(value){

            @Override
            public Object getValue() {
                return 5.toString(value);
            }
        };
    }

    public String getImage() {
        return this.image;
    }

    public String toString() {
        return this.image;
    }

    @Override
    public Object accept(ExpressionVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public String getParameterValue() {
        return this.image;
    }

    protected static String convertString(String str) {
        StringBuilder buf = new StringBuilder();
        boolean escaped = false;
        int unicode = 0;
        int value = 0;
        int octal = 0;
        boolean consumed = false;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (octal > 0) {
                if (value >= 48 && value <= 55) {
                    value = value << 3 | Character.digit(ch, 8);
                    --octal;
                    consumed = true;
                } else {
                    octal = 0;
                }
                if (octal == 0) {
                    buf.append((char)value);
                    value = 0;
                }
            }
            if (consumed) continue;
            if (unicode > 0) {
                value = value << 4 | Character.digit(ch, 16);
                if (--unicode != 0) continue;
                buf.append((char)value);
                value = 0;
                continue;
            }
            if (escaped) {
                if (ch == 'u' || ch == 'U') {
                    unicode = 4;
                } else if (ch >= '0' && ch <= '7') {
                    octal = ch > '3' ? 1 : 2;
                    value = Character.digit(ch, 8);
                } else {
                    switch (ch) {
                        case 'b': {
                            buf.append('\b');
                            break;
                        }
                        case 'f': {
                            buf.append('\f');
                            break;
                        }
                        case 'n': {
                            buf.append('\n');
                            break;
                        }
                        case 'r': {
                            buf.append('\r');
                            break;
                        }
                        case 't': {
                            buf.append('\t');
                            break;
                        }
                        case '\'': {
                            buf.append('\'');
                            break;
                        }
                        case '\"': {
                            buf.append('\"');
                            break;
                        }
                        case '\\': {
                            buf.append('\\');
                            break;
                        }
                    }
                }
                escaped = false;
                continue;
            }
            if (ch == '\\') {
                escaped = true;
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    protected static Boolean toBoolean(String value) {
        return Boolean.valueOf(value);
    }

    protected static Number toIntegerLiteral(String value) {
        String literal = value.replaceAll("_", "");
        int radix = 10;
        int offset = 0;
        if (Pattern.compile("^0[xX]").matcher(literal).find()) {
            radix = 16;
            offset = 2;
        } else if (Pattern.compile("^0[bB]").matcher(literal).find()) {
            radix = 2;
            offset = 2;
        } else if (Pattern.compile("^0[0-7]").matcher(literal).find()) {
            radix = 8;
            offset = 1;
        }
        Number result = Pattern.compile("[lL]$").matcher(literal).find() ? (Number)Long.valueOf(literal.substring(offset, literal.length() - 1), radix) : (Number)Integer.valueOf(literal.substring(offset), radix);
        return result;
    }

    protected static Number toFloatingPointLiteral(String value) {
        String literal = value.replaceAll("_", "");
        Number result = Pattern.compile("[dD]$").matcher(literal).find() ? (Number)Double.valueOf(literal.substring(0, literal.length() - 1)) : (Number)(Pattern.compile("[fF]$").matcher(literal).find() ? Float.valueOf(literal.substring(0, literal.length() - 1)) : Float.valueOf(literal));
        return result;
    }

    protected static Character toChar(String value) throws IllegalArgumentException {
        if (!value.startsWith("'") && !value.endsWith("'")) {
            throw new IllegalArgumentException("Character must be single quoted.");
        }
        String literal = Constant.convertString(value.substring(1, value.length() - 1));
        if (literal.length() != 1) {
            throw new IllegalArgumentException("Only one character allowed in character constants.");
        }
        return Character.valueOf(literal.charAt(0));
    }

    protected static String toString(String value) throws IllegalArgumentException {
        if (value.length() < 2 && !value.startsWith("\"") && !value.endsWith("\"")) {
            throw new IllegalArgumentException("String must be double quoted.");
        }
        return Constant.convertString(value.substring(1, value.length() - 1));
    }
}

