/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.Stripifier;
import java.util.ArrayList;

public class StripifierStats {
    int numStrips = 0;
    int numVerts = 0;
    int minStripLen = 10000;
    int maxStripLen = 0;
    int totalTris = 0;
    int numFaces = 0;
    long time = 0L;
    int[] counts = new int[14];
    boolean noData = true;

    public int getNumOrigTris() {
        return this.numFaces;
    }

    public int getNumOrigVerts() {
        return this.numFaces * 3;
    }

    public int getNumStrips() {
        return this.numStrips;
    }

    public int getNumVerts() {
        return this.numVerts;
    }

    public int getTotalTris() {
        return this.totalTris;
    }

    public int getMinStripLength() {
        return this.minStripLen;
    }

    public int getMaxStripLength() {
        return this.maxStripLen;
    }

    public double getAvgStripLength() {
        return (double)this.totalTris / (double)this.numStrips;
    }

    public double getAvgNumVertsPerTri() {
        return (double)this.numVerts / (double)this.totalTris;
    }

    public long getTotalTime() {
        return this.time;
    }

    public int[] getStripLengthCounts() {
        return this.counts;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("num orig tris:        " + this.numFaces + "\n" + "num orig vertices:    " + this.numFaces * 3 + "\n" + "number of strips:     " + this.numStrips + "\n" + "number of vertices:   " + this.numVerts + "\n" + "total tris:           " + this.totalTris + "\n" + "min strip length:     " + this.minStripLen + "\n" + "max strip length:     " + this.maxStripLen + "\n" + "avg strip length:     " + (double)this.totalTris / (double)this.numStrips + "\n" + "avg num verts/tri:    " + (double)this.numVerts / (double)this.totalTris + "\n" + "total time:           " + this.time + "\n" + "strip length distribution:\n");
        for (int i = 0; i < 9; ++i) {
            stringBuffer.append("  " + (i + 1) + "=" + this.counts[i]);
        }
        stringBuffer.append("  10-19=" + this.counts[9]);
        stringBuffer.append("  20-49=" + this.counts[10]);
        stringBuffer.append("  50-99=" + this.counts[11]);
        stringBuffer.append("  100-999=" + this.counts[12]);
        stringBuffer.append("  1000 or more=" + this.counts[13] + "\n");
        return stringBuffer.toString();
    }

    public void clearData() {
        this.noData = true;
        this.numStrips = 0;
        this.numVerts = 0;
        this.minStripLen = 10000;
        this.maxStripLen = 0;
        this.totalTris = 0;
        this.numFaces = 0;
        this.time = 0L;
        this.counts = new int[14];
    }

    void updateInfo(long l, ArrayList arrayList, int n) {
        this.noData = false;
        this.time += l;
        this.numStrips += arrayList.size();
        int n2 = 0;
        int n3 = 10000;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            Stripifier.Istream istream = (Stripifier.Istream)arrayList.get(i);
            int n6 = istream.length;
            int n7 = n6 - 2;
            n2 += n6;
            if (n7 < n3) {
                n3 = n7;
            }
            if (n7 > n4) {
                n4 = n7;
            }
            n5 += n7;
            if (n7 <= 9) {
                int n8 = n7 - 1;
                this.counts[n8] = this.counts[n8] + 1;
                continue;
            }
            if (n7 < 20) {
                this.counts[9] = this.counts[9] + 1;
                continue;
            }
            if (n7 < 50) {
                this.counts[10] = this.counts[10] + 1;
                continue;
            }
            if (n7 < 100) {
                this.counts[11] = this.counts[11] + 1;
                continue;
            }
            if (n7 < 1000) {
                this.counts[12] = this.counts[12] + 1;
                continue;
            }
            this.counts[13] = this.counts[13] + 1;
        }
        this.numVerts += n2;
        if (n3 < this.minStripLen) {
            this.minStripLen = n3;
        }
        if (n4 > this.maxStripLen) {
            this.maxStripLen = n4;
        }
        this.totalTris += n5;
        this.numFaces += n;
    }

    void updateInfo(long l, int n, int[] nArray, int n2) {
        this.noData = false;
        this.time += l;
        this.numStrips += n;
        int n3 = 0;
        int n4 = 10000;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n; ++i) {
            int n7 = nArray[i];
            int n8 = n7 - 2;
            this.numVerts += n7;
            if (n8 < n4) {
                n4 = n8;
            }
            if (n8 > n5) {
                n5 = n8;
            }
            this.totalTris += n8;
            if (n8 <= 9) {
                int n9 = n8 - 1;
                this.counts[n9] = this.counts[n9] + 1;
                continue;
            }
            if (n8 < 20) {
                this.counts[9] = this.counts[9] + 1;
                continue;
            }
            if (n8 < 50) {
                this.counts[10] = this.counts[10] + 1;
                continue;
            }
            if (n8 < 100) {
                this.counts[11] = this.counts[11] + 1;
                continue;
            }
            if (n8 < 1000) {
                this.counts[12] = this.counts[12] + 1;
                continue;
            }
            this.counts[13] = this.counts[13] + 1;
        }
        this.numVerts += n3;
        if (n4 < this.minStripLen) {
            this.minStripLen = n4;
        }
        if (n5 > this.maxStripLen) {
            this.maxStripLen = n5;
        }
        this.totalTris += n6;
        this.numFaces += n2;
    }

    StripifierStats() {
    }
}

