/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.ui;

import com.jogamp.graph.ui.Container;
import com.jogamp.graph.ui.Shape;
import com.jogamp.opengl.util.PMVMatrix;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class TreeTool {
    public static boolean forOne(List<Shape> list, PMVMatrix pMVMatrix, Shape shape, Runnable runnable) {
        for (int i = 0; i < list.size(); ++i) {
            Container container;
            Shape shape2 = list.get(i);
            if (shape2.equals(shape)) {
                pMVMatrix.glPushMatrix();
                shape2.setTransform(pMVMatrix);
                runnable.run();
                pMVMatrix.glPopMatrix();
                return true;
            }
            if (!(shape2 instanceof Container) || !(container = (Container)((Object)shape2)).contains(shape)) continue;
            pMVMatrix.glPushMatrix();
            shape2.setTransform(pMVMatrix);
            boolean bl = container.forOne(pMVMatrix, shape, runnable);
            pMVMatrix.glPopMatrix();
            if (!bl) {
                throw new InternalError("Not found " + shape + " in " + container + ", but contained");
            }
            return true;
        }
        return false;
    }

    public static boolean forAll(List<Shape> list, Shape.Visitor1 visitor1) {
        for (int i = 0; i < list.size(); ++i) {
            Shape shape = list.get(i);
            boolean bl = visitor1.visit(shape);
            if (!bl && shape instanceof Container) {
                Container container = (Container)((Object)shape);
                bl = container.forAll(visitor1);
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public static boolean forAll(List<Shape> list, PMVMatrix pMVMatrix, Shape.Visitor2 visitor2) {
        for (int i = 0; i < list.size(); ++i) {
            Shape shape = list.get(i);
            pMVMatrix.glPushMatrix();
            shape.setTransform(pMVMatrix);
            boolean bl = visitor2.visit(shape, pMVMatrix);
            if (!bl && shape instanceof Container) {
                Container container = (Container)((Object)shape);
                bl = container.forAll(pMVMatrix, visitor2);
            }
            pMVMatrix.glPopMatrix();
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public static boolean forSortedAll(Comparator<Shape> comparator, List<Shape> list, PMVMatrix pMVMatrix, Shape.Visitor2 visitor2) {
        Object[] objectArray = list.toArray();
        Arrays.sort(objectArray, comparator);
        for (int i = 0; i < objectArray.length; ++i) {
            Shape shape = (Shape)objectArray[i];
            pMVMatrix.glPushMatrix();
            shape.setTransform(pMVMatrix);
            boolean bl = visitor2.visit(shape, pMVMatrix);
            if (!bl && shape instanceof Container) {
                Container container = (Container)((Object)shape);
                bl = container.forSortedAll(comparator, pMVMatrix, visitor2);
            }
            pMVMatrix.glPopMatrix();
            if (!bl) continue;
            return true;
        }
        return false;
    }
}

