/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.juife.wizard.UserInputPage;
import org.jsampler.AudioDeviceModel;
import org.jsampler.CC;
import org.jsampler.event.ListEvent;
import org.jsampler.event.ListListener;
import org.jsampler.view.classic.ClassicI18n;
import org.jsampler.view.std.JSNewAudioDeviceDlg;
import org.linuxsampler.lscp.AudioOutputDevice;

class AudioDeviceWizardPage
extends UserInputPage {
    private final JLabel lDevice = new JLabel(ClassicI18n.i18n.getLabel("AudioDeviceWizardPage.lDevice"));
    private final JComboBox cbDevices = new JComboBox();
    private final JButton btnNewDevice = new JButton(ClassicI18n.i18n.getButtonLabel("AudioDeviceWizardPage.btnNewDevice"));
    private final Handler handler = new Handler();

    AudioDeviceWizardPage() {
        super(ClassicI18n.i18n.getLabel("AudioDeviceWizardPage.subtitle"));
        this.setMainInstructions(ClassicI18n.i18n.getLabel("AudioDeviceWizardPage.mainInstructions"));
        this.setAdditionalInstructions(ClassicI18n.i18n.getLabel("AudioDeviceWizardPage.additionalInstructions"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.lDevice);
        jPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        for (AudioDeviceModel audioDeviceModel : CC.getSamplerModel().getAudioDevices()) {
            this.cbDevices.addItem(audioDeviceModel.getDeviceInfo());
        }
        this.cbDevices.setMaximumSize(this.cbDevices.getPreferredSize());
        if (this.cbDevices.getItemCount() == 0) {
            this.cbDevices.setEnabled(false);
        }
        jPanel.add(this.cbDevices);
        CC.getSamplerModel().addAudioDeviceListListener(this.getHandler());
        jPanel.add(Box.createRigidArea(new Dimension(12, 0)));
        jPanel.add(this.btnNewDevice);
        this.setMainPane(jPanel);
        this.btnNewDevice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new JSNewAudioDeviceDlg(AudioDeviceWizardPage.this.getWizardDialog()).setVisible(true);
            }
        });
    }

    public AudioOutputDevice getSelectedDevice() {
        return (AudioOutputDevice)this.cbDevices.getSelectedItem();
    }

    private Handler getHandler() {
        return this.handler;
    }

    private class Handler
    implements ListListener<AudioDeviceModel> {
        private Handler() {
        }

        @Override
        public void entryAdded(ListEvent<AudioDeviceModel> listEvent) {
            this.updateDeviceList(listEvent.getEntry().getDeviceInfo());
        }

        @Override
        public void entryRemoved(ListEvent<AudioDeviceModel> listEvent) {
            this.updateDeviceList(null);
        }

        private void updateDeviceList(AudioOutputDevice audioOutputDevice) {
            AudioDeviceWizardPage.this.cbDevices.removeAllItems();
            for (AudioDeviceModel audioDeviceModel : CC.getSamplerModel().getAudioDevices()) {
                AudioDeviceWizardPage.this.cbDevices.addItem(audioDeviceModel.getDeviceInfo());
            }
            if (AudioDeviceWizardPage.this.cbDevices.getItemCount() == 0) {
                AudioDeviceWizardPage.this.cbDevices.setEnabled(false);
            } else {
                AudioDeviceWizardPage.this.cbDevices.setEnabled(true);
                AudioDeviceWizardPage.this.cbDevices.setSelectedItem(audioOutputDevice);
            }
            AudioDeviceWizardPage.this.cbDevices.setMaximumSize(AudioDeviceWizardPage.this.cbDevices.getPreferredSize());
        }
    }
}

