/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.deprecation;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.protege.editor.owl.model.deprecation.DeprecationProfile;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;

public class ReparentVisitor
implements OWLEntityVisitorEx<Optional<OWLAxiom>> {
    @Nonnull
    private final DeprecationProfile strategy;
    @Nonnull
    private final OWLDataFactory dataFactory;

    public ReparentVisitor(@Nonnull DeprecationProfile strategy, @Nonnull OWLDataFactory dataFactory) {
        this.strategy = (DeprecationProfile)Preconditions.checkNotNull((Object)strategy);
        this.dataFactory = (OWLDataFactory)Preconditions.checkNotNull((Object)dataFactory);
    }

    @Nonnull
    public Optional<OWLAxiom> visit(@Nonnull OWLClass cls) {
        return this.strategy.getDeprecatedClassParentIri().map(parent -> this.dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)cls, (OWLClassExpression)this.dataFactory.getOWLClass(parent)));
    }

    @Nonnull
    public Optional<OWLAxiom> visit(@Nonnull OWLObjectProperty property) {
        return this.strategy.getDeprecatedObjectPropertyParentIri().map(parent -> this.dataFactory.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)property, (OWLObjectPropertyExpression)this.dataFactory.getOWLObjectProperty(parent)));
    }

    @Nonnull
    public Optional<OWLAxiom> visit(@Nonnull OWLDataProperty property) {
        return this.strategy.getDeprecatedDataPropertyParentIri().map(parent -> this.dataFactory.getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)property, (OWLDataPropertyExpression)this.dataFactory.getOWLDataProperty(parent)));
    }

    @Nonnull
    public Optional<OWLAxiom> visit(@Nonnull OWLNamedIndividual individual) {
        return this.strategy.getDeprecatedIndividualParentClassIri().map(parent -> this.dataFactory.getOWLClassAssertionAxiom((OWLClassExpression)this.dataFactory.getOWLClass(parent), (OWLIndividual)individual));
    }

    @Nonnull
    public Optional<OWLAxiom> visit(@Nonnull OWLDatatype datatype) {
        return Optional.empty();
    }

    @Nonnull
    public Optional<OWLAxiom> visit(@Nonnull OWLAnnotationProperty property) {
        return this.strategy.getDeprecatedAnnotationPropertyParentIri().map(parent -> this.dataFactory.getOWLSubAnnotationPropertyOfAxiom(property, this.dataFactory.getOWLAnnotationProperty(parent)));
    }
}

