/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.latex.renderer;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.AbstractOWLRenderer;
import org.semanticweb.owlapi.io.OWLRendererException;
import org.semanticweb.owlapi.latex.renderer.LatexObjectVisitor;
import org.semanticweb.owlapi.latex.renderer.LatexRendererIOException;
import org.semanticweb.owlapi.latex.renderer.LatexWriter;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.OWLEntityComparator;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;

public class LatexRenderer
extends AbstractOWLRenderer {
    private static final String EMPTYLINE = "\n\n";
    @Nonnull
    private final ShortFormProvider shortFormProvider = new SimpleShortFormProvider();

    private void writeEntitySection(@Nonnull OWLEntity entity, @Nonnull LatexWriter w) {
        w.write("\\subsubsection*{");
        w.write(LatexRenderer.escapeName(this.shortFormProvider.getShortForm(entity)));
        w.write("}\n\n");
    }

    @Nonnull
    private static String escapeName(String name) {
        return name.replace("_", "\\_");
    }

    @Override
    public void render(OWLOntology ontology, Writer writer) throws OWLRendererException {
        try {
            LatexWriter w = new LatexWriter(writer);
            w.write("\\documentclass{article}\n");
            w.write("\\usepackage{breqn}\n");
            w.write("\\parskip 0pt\n");
            w.write("\\parindent 0pt\n");
            w.write("\\oddsidemargin 0cm\n");
            w.write("\\textwidth 19cm\n");
            w.write("\\begin{document}\n\n");
            LatexObjectVisitor renderer = new LatexObjectVisitor(w, ontology.getOWLOntologyManager().getOWLDataFactory());
            Collection<OWLClass> clses = this.sortEntities(ontology.getClassesInSignature());
            if (!clses.isEmpty()) {
                w.write("\\subsection*{Classes}\n\n");
            }
            for (OWLClass oWLClass : clses) {
                assert (oWLClass != null);
                this.writeEntitySection(oWLClass, w);
                for (OWLAxiom ax : LatexRenderer.sortAxioms(ontology.getAxioms(oWLClass, Imports.EXCLUDED))) {
                    renderer.setSubject(oWLClass);
                    ax.accept(renderer);
                    w.write(EMPTYLINE);
                }
            }
            w.write("\\section*{Object properties}");
            for (OWLObjectProperty oWLObjectProperty : this.sortEntities(ontology.getObjectPropertiesInSignature())) {
                assert (oWLObjectProperty != null);
                this.writeEntitySection(oWLObjectProperty, w);
                for (OWLAxiom ax : LatexRenderer.sortAxioms(ontology.getAxioms((OWLObjectPropertyExpression)oWLObjectProperty, Imports.EXCLUDED))) {
                    ax.accept(renderer);
                    w.write(EMPTYLINE);
                }
            }
            w.write("\\section*{Data properties}");
            for (OWLDataProperty oWLDataProperty : this.sortEntities(ontology.getDataPropertiesInSignature())) {
                assert (oWLDataProperty != null);
                this.writeEntitySection(oWLDataProperty, w);
                for (OWLAxiom ax : LatexRenderer.sortAxioms(ontology.getAxioms(oWLDataProperty, Imports.EXCLUDED))) {
                    ax.accept(renderer);
                    w.write(EMPTYLINE);
                }
            }
            w.write("\\section*{Individuals}");
            for (OWLNamedIndividual oWLNamedIndividual : this.sortEntities(ontology.getIndividualsInSignature())) {
                assert (oWLNamedIndividual != null);
                this.writeEntitySection(oWLNamedIndividual, w);
                for (OWLAxiom ax : LatexRenderer.sortAxioms(ontology.getAxioms((OWLIndividual)oWLNamedIndividual, Imports.EXCLUDED))) {
                    ax.accept(renderer);
                    w.write(EMPTYLINE);
                }
            }
            w.write("\\section*{Datatypes}");
            for (OWLDatatype oWLDatatype : this.sortEntities(ontology.getDatatypesInSignature())) {
                assert (oWLDatatype != null);
                this.writeEntitySection(oWLDatatype, w);
                for (OWLAxiom ax : LatexRenderer.sortAxioms(ontology.getAxioms(oWLDatatype, Imports.EXCLUDED))) {
                    ax.accept(renderer);
                    w.write(EMPTYLINE);
                }
            }
            writer.write("\\end{document}\n");
            writer.flush();
        }
        catch (IOException e) {
            throw new LatexRendererIOException(e);
        }
    }

    private <T extends OWLEntity> Collection<T> sortEntities(Set<T> entites) {
        ArrayList<T> list = new ArrayList<T>(entites);
        OWLEntityComparator entityComparator = new OWLEntityComparator(this.shortFormProvider);
        Collections.sort(list, entityComparator);
        return list;
    }

    private static Collection<OWLAxiom> sortAxioms(Set<? extends OWLAxiom> axioms) {
        ArrayList<OWLAxiom> list = new ArrayList<OWLAxiom>(axioms);
        Collections.sort(list, new OWLAxiomComparator());
        return list;
    }

    private static class OWLAxiomComparator
    implements Comparator<OWLAxiom>,
    Serializable {
        private static final long serialVersionUID = 40000L;

        OWLAxiomComparator() {
        }

        @Override
        public int compare(OWLAxiom o1, OWLAxiom o2) {
            int index1 = o1.getAxiomType().getIndex();
            int index2 = o2.getAxiomType().getIndex();
            return index1 - index2;
        }
    }
}

