/*
 * Decompiled with CFR 0.152.
 */
package hughai;

import com.springrts.ai.oo.AIFloat3;
import com.springrts.ai.oo.clb.OOAICallback;
import com.springrts.ai.oo.clb.Unit;
import com.springrts.ai.oo.clb.UnitDef;
import com.springrts.ai.oo.clb.WeaponDef;
import hughai.CSAI;
import hughai.GameAdapter;
import hughai.PlayerObjects;
import hughai.VoiceCommandHandler;
import hughai.basictypes.Float3;
import hughai.basictypes.TerrainPos;
import hughai.ui.MainUI;
import hughai.unitdata.UnitController;
import hughai.unitdata.UnitDefHelp;
import hughai.utils.DrawingUtils;
import hughai.utils.LogFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class EnemyTracker {
    List<EnemyListener> listeners = new ArrayList<EnemyListener>();
    HashSet<Unit> EnemyUnits = new HashSet();
    HashMap<Unit, TerrainPos> EnemyPosByStaticUnit = new HashMap();
    HashMap<Unit, UnitDef> EnemyUnitDefByUnit = new HashMap();
    HashMap<Unit, TerrainPos> DynamicEnemyLastSeenPos = new HashMap();
    HashMap<Unit, Integer> DynamicEnemyLastSeenFrame = new HashMap();
    PlayerObjects playerObjects;
    CSAI csai;
    OOAICallback aicallback;
    LogFile logfile;
    UnitDefHelp unitdefhelp;
    UnitController unitcontroller;
    DrawingUtils drawingUtils;
    boolean autoshowenemies = false;

    EnemyTracker(PlayerObjects playerObjects) {
        this.playerObjects = playerObjects;
        this.csai = playerObjects.getCSAI();
        this.aicallback = this.csai.aicallback;
        this.logfile = playerObjects.getLogFile();
        this.drawingUtils = playerObjects.getDrawingUtils();
        this.autoshowenemies = this.csai.DebugOn;
        this.unitcontroller = playerObjects.getUnitController();
        this.csai.registerGameListener(new GameListenerHandler());
        this.csai.RegisterVoiceCommand("enemiescount", new VoiceCommandCountEnemies());
        this.csai.RegisterVoiceCommand("autoshowenemieson", new VoiceCommandAutoShowEnemiesOn());
        this.csai.RegisterVoiceCommand("autoshowenemiesoff", new VoiceCommandAutoShowEnemiesOff());
        playerObjects.getMainUI().registerButton("Show enemies", new ButtonShowEnemies());
        this.unitdefhelp = playerObjects.getUnitDefHelp();
    }

    public void registerListener(EnemyListener enemyListener) {
        this.listeners.add(enemyListener);
    }

    public void unregisterGameListener(EnemyListener enemyListener) {
        EnemyListener enemyListener2 = null;
        for (EnemyListener enemyListener3 : this.listeners) {
            if (enemyListener3.getClass() != enemyListener.getClass()) continue;
            enemyListener2 = enemyListener3;
        }
        this.listeners.remove(enemyListener2);
    }

    void ShowEnemies() {
        int n = 0;
        int n2 = 0;
        int n3 = this.playerObjects.getFrameController().frame;
        for (Unit unit : this.DynamicEnemyLastSeenPos.keySet()) {
            TerrainPos terrainPos = this.EnemyPosByStaticUnit.get(unit);
            if (terrainPos != null) {
                this.drawingUtils.DrawUnit("ARMAMD", terrainPos, 0.0f, 1, this.aicallback.getSkirmishAI().getTeamId(), true, true);
                this.drawingUtils.drawText(terrainPos, "" + unit.getUnitId());
                continue;
            }
            TerrainPos terrainPos2 = this.DynamicEnemyLastSeenPos.get(unit);
            if (terrainPos2 != null) {
                int n4;
                int n5 = this.DynamicEnemyLastSeenFrame.get(unit);
                int n6 = n3 - n5;
                if (n6 >= (n4 = 30 * this.playerObjects.getConfig().getMaxTimeToConserveMobileEnemyOnThreatMapGameSeconds())) continue;
                this.drawingUtils.DrawUnit("ARMSAM", terrainPos2, 0.0f, 1, this.aicallback.getSkirmishAI().getTeamId(), true, true);
                this.drawingUtils.drawText(terrainPos2, "" + unit.getUnitId());
                ++n;
                continue;
            }
            ++n2;
        }
        this.logfile.WriteLine("Number enemies=" + this.EnemyUnits.size() + " Static enemies=" + this.EnemyPosByStaticUnit.size() + " Dynamic enemies with lastpos=" + n + " Enemies with no known location at all=" + n2);
    }

    public void LoadExistingUnits() {
        List list = this.aicallback.getEnemyUnitsInRadarAndLos();
        for (Unit unit : list) {
            this.logfile.WriteLine("enemy unit existing: " + unit.getUnitId());
            this.AddEnemy(unit);
        }
    }

    void AddEnemy(Unit unit) {
        TerrainPos terrainPos;
        UnitDef unitDef;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = this.playerObjects.getFrameController().getFrame();
        if (!this.EnemyUnits.contains(unit)) {
            this.EnemyUnits.add(unit);
            this.logfile.WriteLine("EnemyController acquired new enemy: " + unit.getUnitId());
            bl = true;
        }
        if ((unitDef = this.EnemyUnitDefByUnit.get(unit)) == null && (unitDef = unit.getDef()) != null) {
            this.logfile.WriteLine("acquired unitdef for " + unit.getUnitId() + " " + unitDef.getName());
            this.EnemyUnitDefByUnit.put(unit, unitDef);
            bl2 = true;
        }
        if ((terrainPos = TerrainPos.fromAIFloat3(unit.getPos())).equals(new Float3())) {
            terrainPos = null;
        }
        if (terrainPos != null && !terrainPos.equals(new Float3())) {
            bl3 = true;
            this.DynamicEnemyLastSeenPos.put(unit, terrainPos);
            this.DynamicEnemyLastSeenFrame.put(unit, n);
            if (!this.EnemyPosByStaticUnit.containsKey(unit) && unitDef != null && !this.unitdefhelp.IsMobile(unitDef)) {
                this.EnemyPosByStaticUnit.put(unit, terrainPos);
                bl4 = true;
            }
            if (bl) {
                for (EnemyListener enemyListener : this.listeners) {
                    enemyListener.AcquiredEnemy(unit);
                }
            }
            if (bl2) {
                for (EnemyListener enemyListener : this.listeners) {
                    enemyListener.AcquiredEnemyUnitDef(unit, unitDef);
                }
            }
            if (bl3) {
                for (EnemyListener enemyListener : this.listeners) {
                    enemyListener.AcquiredEnemyPos(unit, terrainPos);
                }
            }
            if (bl4) {
                for (EnemyListener enemyListener : this.listeners) {
                    enemyListener.AcquiredStaticEnemy(unit, unitDef, terrainPos);
                }
            }
        }
    }

    void RemoveEnemy(Unit unit) {
        this.EnemyPosByStaticUnit.remove(unit);
        this.EnemyUnitDefByUnit.remove(unit);
        this.EnemyUnits.remove(unit);
        this.DynamicEnemyLastSeenFrame.remove(unit);
        this.DynamicEnemyLastSeenPos.remove(unit);
        this.logfile.WriteLine("EnemyController Enemy removed: " + unit);
        for (EnemyListener enemyListener : this.listeners) {
            enemyListener.EnemyDestroyed(unit);
        }
    }

    public HashSet<Unit> getEnemyUnits() {
        return this.EnemyUnits;
    }

    public HashMap<Unit, TerrainPos> getEnemyPosByStaticUnit() {
        return this.EnemyPosByStaticUnit;
    }

    public TerrainPos getPos(Unit unit) {
        return this.DynamicEnemyLastSeenPos.get(unit);
    }

    public int getLastLocatedFrame(Unit unit) {
        return this.DynamicEnemyLastSeenFrame.get(unit);
    }

    public HashMap<Unit, UnitDef> getEnemyUnitDefByUnit() {
        return this.EnemyUnitDefByUnit;
    }

    public class VoiceCommandCountEnemies
    implements VoiceCommandHandler {
        @Override
        public void commandReceived(String string, String[] stringArray, int n) {
            EnemyTracker.this.csai.SendTextMsg("Number enemies: " + EnemyTracker.this.EnemyUnits.size());
            EnemyTracker.this.csai.SendTextMsg("Static enemies: " + EnemyTracker.this.EnemyPosByStaticUnit.size());
            EnemyTracker.this.logfile.WriteLine("Number enemies: " + EnemyTracker.this.EnemyUnits.size());
        }
    }

    class ButtonShowEnemies
    implements MainUI.ButtonHandler {
        ButtonShowEnemies() {
        }

        @Override
        public void go() {
            EnemyTracker.this.ShowEnemies();
        }
    }

    public class VoiceCommandShowEnemies
    implements VoiceCommandHandler {
        @Override
        public void commandReceived(String string, String[] stringArray, int n) {
            EnemyTracker.this.ShowEnemies();
        }
    }

    public class VoiceCommandAutoShowEnemiesOff
    implements VoiceCommandHandler {
        @Override
        public void commandReceived(String string, String[] stringArray, int n) {
            EnemyTracker.this.autoshowenemies = false;
        }
    }

    public class VoiceCommandAutoShowEnemiesOn
    implements VoiceCommandHandler {
        @Override
        public void commandReceived(String string, String[] stringArray, int n) {
            EnemyTracker.this.autoshowenemies = true;
            EnemyTracker.this.ShowEnemies();
        }
    }

    class GameListenerHandler
    extends GameAdapter {
        GameListenerHandler() {
        }

        @Override
        public void UnitDamaged(Unit unit, Unit unit2, float f, AIFloat3 aIFloat3, WeaponDef weaponDef, boolean bl) {
        }

        @Override
        public void EnemyEnterRadar(Unit unit) {
            EnemyTracker.this.AddEnemy(unit);
        }

        @Override
        public void EnemyEnterLOS(Unit unit) {
            EnemyTracker.this.AddEnemy(unit);
        }

        @Override
        public void EnemyLeaveRadar(Unit unit) {
        }

        @Override
        public void EnemyDestroyed(Unit unit, Unit unit2) {
            EnemyTracker.this.RemoveEnemy(unit);
        }

        @Override
        public void Tick(int n) {
            EnemyTracker.this.logfile.WriteLine("enemytracker maphack: " + EnemyTracker.this.playerObjects.getConfig().isMapHack() + " cheating: " + EnemyTracker.this.aicallback.getCheats().isEnabled());
            if (EnemyTracker.this.playerObjects.getConfig().isMapHack().booleanValue()) {
                Object object22;
                if (!EnemyTracker.this.aicallback.getCheats().isEnabled()) {
                    EnemyTracker.this.csai.sendTextMessage("Maphack enabled.  Very alpha ;-)");
                    EnemyTracker.this.aicallback.getCheats().setEnabled(true);
                }
                List list = EnemyTracker.this.aicallback.getEnemyUnits();
                for (Object object22 : list) {
                    EnemyTracker.this.AddEnemy((Unit)object22);
                }
                ArrayList arrayList = new ArrayList();
                for (Unit unit : EnemyTracker.this.EnemyUnits) {
                    if (list.contains(unit)) continue;
                    arrayList.add(unit);
                }
                object22 = arrayList.iterator();
                while (object22.hasNext()) {
                    Unit unit;
                    unit = (Unit)object22.next();
                    EnemyTracker.this.RemoveEnemy(unit);
                }
            } else {
                if (EnemyTracker.this.aicallback.getCheats().isEnabled()) {
                    EnemyTracker.this.csai.sendTextMessage("Maphack disabled.");
                    EnemyTracker.this.aicallback.getCheats().setEnabled(false);
                }
                for (Unit unit : EnemyTracker.this.unitcontroller.units) {
                    TerrainPos terrainPos2 = EnemyTracker.this.unitcontroller.getPos(unit);
                    UnitDef unitDef = unit.getDef();
                    ArrayList<Unit> arrayList = new ArrayList<Unit>();
                    for (Unit unit2 : EnemyTracker.this.EnemyPosByStaticUnit.keySet()) {
                        TerrainPos terrainPos = EnemyTracker.this.EnemyPosByStaticUnit.get(unit2);
                        if (!(terrainPos.GetSquaredDistance(terrainPos2) < unitDef.getLosRadius() * unitDef.getLosRadius() * 16.0f * 16.0f)) continue;
                        arrayList.add(unit2);
                    }
                    for (Unit unit3 : arrayList) {
                        EnemyTracker.this.RemoveEnemy(unit3);
                    }
                    ArrayList arrayList2 = new ArrayList();
                    for (Unit unit4 : EnemyTracker.this.DynamicEnemyLastSeenPos.keySet()) {
                        TerrainPos terrainPos = EnemyTracker.this.DynamicEnemyLastSeenPos.get(unit4);
                        if (!(terrainPos.GetSquaredDistance(terrainPos2) < unitDef.getLosRadius() * unitDef.getLosRadius() * 16.0f * 16.0f)) continue;
                        arrayList2.add(unit4);
                    }
                    Iterator object3 = arrayList2.iterator();
                    while (object3.hasNext()) {
                        Unit unit5 = (Unit)object3.next();
                        EnemyTracker.this.DynamicEnemyLastSeenPos.remove(unit5);
                    }
                }
                if (EnemyTracker.this.csai.DebugOn) {
                    // empty if block
                }
            }
        }
    }

    public static class EnemyAdapter
    implements EnemyListener {
        @Override
        public void AcquiredEnemy(Unit unit) {
        }

        @Override
        public void AcquiredEnemyUnitDef(Unit unit, UnitDef unitDef) {
        }

        @Override
        public void AcquiredEnemyPos(Unit unit, TerrainPos terrainPos) {
        }

        @Override
        public void AcquiredStaticEnemy(Unit unit, UnitDef unitDef, TerrainPos terrainPos) {
        }

        @Override
        public void EnemyDestroyed(Unit unit) {
        }
    }

    public static interface EnemyListener {
        public void AcquiredEnemy(Unit var1);

        public void AcquiredEnemyUnitDef(Unit var1, UnitDef var2);

        public void AcquiredEnemyPos(Unit var1, TerrainPos var2);

        public void AcquiredStaticEnemy(Unit var1, UnitDef var2, TerrainPos var3);

        public void EnemyDestroyed(Unit var1);
    }
}

